'Arbitray precision math: calculating factorials
'Idea is to perform calculations with more precision than is normal with integer and float datatypes
option base 0
const limit = 65536 'maximum number of digits
const tbase = 10
dim string  tdigit$(9) = ("0", "1", "2", "3", "4", "5", "6", "7", "8", "9")
dim integer digit(limit)  'the big number
dim integer carry, d      'assistants during multiplication
dim integer last, i       'indices to the big number's digits
const fl = 47             'target factorial to solve

for i = 1 to limit  
  digit(i) = 0 
next i

digit(1) = 1  'the big number starts with 1
last = 1      'it's highest-order digit is number 1

for n = 1 to fl
  carry = 0
  for i = 1 to last  'step along every digit
    d = digit(i) * n + carry
    digit(i) = d mod tbase  'the low-order digit of the result
    carry = d \ tbase  'Note: MUST use \ for integer division, not /, the carry to the next digit
  next i

  do while carry > 0 'store the carry in the big number
    if last >= limit then print "Overflow!") 
    inc last
    digit(last) = carry mod tbase
    carry = carry \ tbase
  loop

  for i = last to 1 step -1
    print tdigit$(digit(i));
  next i
  print " ="; n; "!"
next n

do : loop

